#include <stdio.h>
#include <string.h>
#include <malloc.h>

//Defines
#define NUM_OF_ENTRIES 5
/**************************************/

//structs
struct Entry
{
	char name[80];
	char email[30];
	char addr[80];
	int  phone_num;
};

struct Heap_Entry
{
	char *name;
	char *email;
	char *addr;
	int  phone_num;
};

typedef struct Entry Entry_t;
typedef struct Heap_Entry Heap_Entry_t;
/****************************************************/
//prototypes

//functions to be implemented
void menu();
int add_entry(Heap_Entry_t **pEntries_array);

void show_entry_by_id(Heap_Entry_t **pEntries_array);
/*
void show_all_entries(Heap_Entry_t **pEntries_array );
void delete_entry_by_id(Heap_Entry_t **pEntries_array);
void delete_all_entries(Heap_Entry_t **pEntries_array);
*/
/**************************************/

////////////////////////////////////////////////////////////////////////
int main()
{

	Heap_Entry_t *pEntries_array[NUM_OF_ENTRIES];
	char option;
	char id=0;
	
	do {
		menu();
		printf ("youre selection: \n\n");
		flushall();
		scanf ("%c",&option);
		switch (option)
		{
			case '1': 
				add_entry(&pEntries_array[id++]);
			  break;
			case '2':
			{
				char chosen_id=0;
				printf ("Please enter id to show:\n");
				scanf ("%d",&chosen_id);
			    show_entry_by_id(&pEntries_array[chosen_id]);
				break;
			}
		case 'q': 	 printf (" Bye Bye... ");

			break;

		default: 
			printf (" Please enter again ");
			break;
		}
	}while (option!='q');
	return 0;
}

////////////////////////////////////////////////////////////////////////
void menu()
{
	printf (" phone book DataBase \n");
	printf ("_______________\n\n\n");
	printf (" Please Enter selection:\n");
	printf (" 1. Add entry \n");
	printf (" 2. Show entry by id \n");
	printf (" 3. Show all entries  \n");
	printf (" 4. Delete entry by id\n");
	printf (" 5. Delete all entries  \n");
	printf (" 6. defragment list  \n");

	printf (" q. Quit \n\n");

}
////////////////////////////////////////////////////////////////////////	
int add_entry(Heap_Entry_t **pEntries_array)
{	
	Entry_t entry;
	Heap_Entry_t* pEntry = NULL;
	int name_len=0;
	int email_len=0;
	int addr_len=0;

	printf("please add entry to phone book\n");
	printf (" Please Enter name:\n");
	scanf("%s",entry.name);
	printf (" Please Enter email:\n");
	scanf("%s",entry.email);
	printf (" Please Enter addr:\n");
	scanf("%s",entry.addr);
	printf (" Please Enter phone number:\n");
	scanf("%d",&(entry.phone_num));
	
	//calculations
	 name_len=1+strlen(entry.name);
	 email_len=1+strlen(entry.email);
	 addr_len=1+strlen(entry.addr);
	
	 /**** allocation from heap ***/
	 pEntry = (Heap_Entry_t*)malloc(sizeof(Heap_Entry_t));
	if(NULL==pEntry)
	{
		printf("error in Entry Mem Allocation");
		return -1;
	}

	*pEntries_array=pEntry;
	
	
	//allocate name
	pEntry->name=(char *)malloc(name_len);
	if(NULL==pEntry->name)
	{
		printf("error in pEntry->name Mem Allocation");
		return -2;
	}

	//allocate email
	pEntry->email =(char *)malloc(email_len);
	if(NULL==pEntry->email)
	{
		printf("error in pEntry->email Mem Allocation");
		return -3;
	}
	
	//allocate addr
	pEntry->addr=(char *)malloc(addr_len);
	if(NULL==pEntry->addr)
	{
		printf("error in pEntry->addr Mem Allocation");
		return -4;
	}
	
	 /**** copy from stack to heap ***/
	strcpy(pEntry->name,entry.name);
	strcpy(pEntry->email,entry.email);
	strcpy(pEntry->addr,entry.addr);
	pEntry->phone_num = entry.phone_num;

	return 0;

}
////////////////////////////////////////////////////////////////////////
void show_entry_by_id(Heap_Entry_t **pEntries_array)
{
	Heap_Entry_t* pEntry =	*pEntries_array;
	printf(" pEntry->name = %s\n",pEntry->name);
	printf(" pEntry->email= %s\n",pEntry->email);
	printf(" pEntry->addr = %s\n",pEntry->addr);
	printf(" pEntry->phone_num= %d\n",pEntry->phone_num);

}
